/*
 * WebStartEx, launcher for WebStart application that need access to resources outside the jar files.
 * Copyright (C) 2003  Christopher Deckers (chrriis@brainlex.com)
 * http://chrriis.brainlex.com/webstartex
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package chrriis.webstartex;


import java.io.Serializable;
import java.util.Vector;
import java.util.List;

/**
 * The configuration that is used to save settings for fast update.
 * @author Christopher Deckers
 * @version 1.0
 */
class Configuration implements Serializable {

  /**
   * Construct a Configuration
   */
  Configuration() {
  }

  /** The list of files that were extracted. */
  protected List extractedFileList = new Vector();

  /**
   * Get the list of extracted files.
   * @return the list of files that were extracted.
   */
  public List getExtractedFileList() {
    return extractedFileList;
  }

  /**
   * Set the list of files that were extracted.
   * @param extractedFileList the list of extracted files.
   */
  public void setExtractedFileList(List extractedFileList) {
    this.extractedFileList = extractedFileList;
  }

  /** The list of archive names. */
  protected List archiveNameList = new Vector();
  /** The list of archive time stamps. */
  protected List archiveTimeStampList = new Vector();

  /**
   * Get the time stamp of some archive information.
   * @param name The name of the archive.
   * @return The time stamp, or -1 if not found.
   */
  public long getArchiveTimeStamp(String name) {
    int index = archiveNameList.indexOf(name);
    if(index != -1) {
      return ((Long)archiveTimeStampList.get(index)).longValue();
    } else
      return -1;
  }

  /**
   * Set the time stamp of an archive. Thsi adds the archive information if not
   * present.
   * @param name The name of the archive for which to add or update the time stamp.
   * @param timeStamp The new time stamp.
   */
  public void setArchiveTimeStamp(String name, long timeStamp) {
    int index = archiveNameList.indexOf(name);
    if(index == -1) {
      archiveNameList.add(name);
      archiveTimeStampList.add(new Long(timeStamp));
    } else
      archiveTimeStampList.set(index, new Long(timeStamp));
  }

}