/*
 * Decompiled with CFR 0.152.
 */
package chrriis.webstartex;

import chrriis.webstartex.Configuration;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public class WebstartEx {
    protected final String INDEX_TO_REMOVE_PROPERTY = "webstartex.remove";
    protected final String INDEX_TO_KEEP_PROPERTY = "webstartex.keep";
    protected final String DEFAULT_INDEX_TO_REMOVE = "webstartex.remove";
    protected final String DEFAULT_INDEX_TO_KEEP = "webstartex.keep";
    protected final String CONFIGURATION_FILE = ".webstartex.conf";
    static /* synthetic */ Class array$Ljava$lang$String;

    protected WebstartEx() {
    }

    protected Configuration loadConfiguration() {
        Configuration configuration = null;
        File configurationFile = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(System.getProperty("user.dir")))).append("/").append(".webstartex.conf"))));
        if (configurationFile.exists()) {
            try {
                ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(configurationFile)));
                configuration = (Configuration)in.readObject();
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return configuration;
    }

    protected void saveConfiguration(Configuration configuration) {
        File configurationFile = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(System.getProperty("user.dir")))).append("/").append(".webstartex.conf"))));
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(configurationFile));
            out.writeObject(configuration);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void loadContent(String applicationJar) {
        String indexToKeep;
        String indexToRemove;
        String containerArchivePath = this.getClass().getClassLoader().getResource(String.valueOf(String.valueOf(this.getClass().getName().replace('.', '/'))).concat(".class")).getPath();
        String downloadPath = null;
        try {
            downloadPath = new File(new URL(containerArchivePath.substring(0, containerArchivePath.lastIndexOf("!/"))).getPath()).getParent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        URL applicationURL = this.getClass().getClassLoader().getResource(applicationJar);
        if (applicationURL == null) {
            throw new IllegalStateException(String.valueOf(String.valueOf(new StringBuffer("The jar application \"").append(applicationJar).append("\" cannot be found!"))));
        }
        String containerCachePath = applicationURL.getPath();
        String downloadCachePath = null;
        try {
            downloadCachePath = new File(URLDecoder.decode(new URL(containerCachePath.substring(0, containerCachePath.lastIndexOf("!/"))).getPath())).getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String userDir = new StringBuffer(downloadCachePath).insert(downloadCachePath.toLowerCase().lastIndexOf(".jar"), "_cache").toString();
        new File(userDir).mkdirs();
        System.setProperty("user.dir", userDir);
        Configuration oldConfiguration = this.loadConfiguration();
        Configuration newConfiguration = new Configuration();
        if (oldConfiguration == null) {
            oldConfiguration = new Configuration();
        }
        if ((indexToRemove = System.getProperty("webstartex.remove")) == null) {
            indexToRemove = "webstartex.remove";
        }
        if ((indexToKeep = System.getProperty("webstartex.keep")) == null) {
            indexToKeep = "webstartex.keep";
        }
        try {
            Vector<URL> list = new Vector<URL>();
            Enumeration<URL> indexEnumeration = this.getClass().getClassLoader().getResources(indexToRemove);
            if (indexEnumeration != null) {
                while (indexEnumeration.hasMoreElements()) {
                    list.add(indexEnumeration.nextElement());
                }
            }
            if ((indexEnumeration = this.getClass().getClassLoader().getResources(indexToKeep)) != null) {
                while (indexEnumeration.hasMoreElements()) {
                    list.add(indexEnumeration.nextElement());
                }
            }
            List fileList = oldConfiguration.getExtractedFileList();
            Vector<String> newFileList = new Vector<String>();
            boolean isConfigurationChanged = false;
            Iterator i = list.iterator();
            while (i.hasNext()) {
                String filePath = ((URL)i.next()).getPath();
                String archivePath = null;
                try {
                    archivePath = new File(URLDecoder.decode(new URL(filePath.substring(0, filePath.lastIndexOf("!/"))).getPath())).getPath();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                File archive = new File(archivePath);
                long timeStamp = archive.lastModified();
                long oldTimeStamp = oldConfiguration.getArchiveTimeStamp(archivePath);
                boolean isModified = oldTimeStamp == (long)-1 || timeStamp != oldTimeStamp;
                newConfiguration.setArchiveTimeStamp(archivePath, timeStamp);
                if (!isModified) continue;
                isConfigurationChanged = true;
                JarFile file = new JarFile(archivePath);
                boolean isKeepIndex = false;
                Enumeration<JarEntry> e = file.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    String content = entry.getName();
                    boolean isIndex = false;
                    if (content.equals(indexToRemove)) {
                        isIndex = true;
                    } else if (content.equals(indexToKeep)) {
                        isIndex = true;
                        isKeepIndex = true;
                    }
                    if (isIndex) continue;
                    File correspondingFile = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(userDir))).append("/").append(content))));
                    correspondingFile.getParentFile().mkdirs();
                    if (entry.isDirectory()) {
                        correspondingFile.mkdir();
                    } else {
                        try {
                            int read;
                            BufferedInputStream in = new BufferedInputStream(file.getInputStream(entry));
                            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(correspondingFile));
                            while ((read = ((InputStream)in).read()) != -1) {
                                ((OutputStream)out).write(read);
                            }
                            ((OutputStream)out).flush();
                            ((OutputStream)out).close();
                            ((InputStream)in).close();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    newFileList.add(content);
                    fileList.remove(content);
                }
                if (isKeepIndex) continue;
                try {
                    JarOutputStream out = new JarOutputStream(new FileOutputStream(archivePath));
                    out.putNextEntry(new ZipEntry(indexToRemove));
                    if (new File(downloadCachePath).equals(new File(archivePath))) {
                        out.putNextEntry(new ZipEntry(applicationJar));
                    }
                    out.flush();
                    out.close();
                    newConfiguration.setArchiveTimeStamp(archivePath, archive.lastModified());
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            if (isConfigurationChanged) {
                i = fileList.iterator();
                while (i.hasNext()) {
                    new File((String)i.next()).delete();
                }
                newConfiguration.setExtractedFileList(newFileList);
                this.saveConfiguration(newConfiguration);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        System.setSecurityManager(null);
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException("The first argument must be a jar file.");
        }
        String program = args[0];
        if (!program.toLowerCase().endsWith(".jar")) {
            throw new IllegalArgumentException("The first argument must be a jar file.");
        }
        new WebstartEx().loadContent(program);
        Method mainMethod = null;
        try {
            final String codeBase = String.valueOf(String.valueOf(System.getProperty("user.dir"))).concat("/");
            URLClassLoader cl = new URLClassLoader(new URL[]{new File(String.valueOf(String.valueOf(codeBase)).concat(String.valueOf(String.valueOf(program)))).toURL()}, ClassLoader.getSystemClassLoader()){

                protected String findLibrary(String libname) {
                    File library = new File(String.valueOf(String.valueOf(codeBase)).concat(String.valueOf(String.valueOf(System.mapLibraryName(libname)))));
                    if (library.exists()) {
                        return library.getAbsolutePath();
                    }
                    return super.findLibrary(libname);
                }
            };
            String mainClass = new JarFile(String.valueOf(String.valueOf(codeBase)).concat(String.valueOf(String.valueOf(program)))).getManifest().getMainAttributes().getValue("Main-Class");
            mainMethod = Class.forName(mainClass, true, cl).getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = WebstartEx.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Could not load the jar file.");
        }
        if (mainMethod != null) {
            String[] arguments = new String[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                arguments[i - 1] = args[i];
            }
            try {
                mainMethod.invoke(null, new Object[]{arguments});
            }
            catch (InvocationTargetException e) {
                e.getTargetException().printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

