/*
 * AWTEnabler, enables java AWT/Swing GUI components that are disabled.
 * Copyright (C) 2003  Christopher Deckers (chrriis@brainlex.com)
 * http://chrriis.brainlex.com/awtenabler
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package chrriis.awt.enabler;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;

import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

/**
 * @author Christopher Deckers
 */
public class AwtEnabler extends JFrame {

  private boolean isActive = false;

  private class EnablerEventQueue extends EventQueue {
    protected void dispatchEvent(AWTEvent event) {
      boolean isDispatching = true;
      if(isActive) {
        if(event instanceof MouseEvent) {
          MouseEvent me = (MouseEvent)event;

          if((me.getModifiers() & MouseEvent.BUTTON1_MASK) != 0) {
            Object source = me.getSource();
            if(source instanceof Component) {
              Component component = (Component)source;
              component = SwingUtilities.getDeepestComponentAt(component, me.getX(), me.getY());
              if(component != null && !component.isEnabled()) {
                switch(me.getID()) {
                  case MouseEvent.MOUSE_CLICKED:
                    component.setEnabled(true);
                  case MouseEvent.MOUSE_PRESSED:
                  case MouseEvent.MOUSE_RELEASED:
                    isDispatching = false;
                    break;
                }
              }
            }
          }
        }
      }
      if(isDispatching) {
        super.dispatchEvent(event);
      }
    }
  }

  private AwtEnabler() {
    super("Awt/Swing Enabler");
    setIconImage(new ImageIcon(getClass().getResource("resources/ASE_32_Opaque.gif")).getImage());
    final EnablerEventQueue queue = new EnablerEventQueue();
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(queue);
      }
    });

    Container content = getContentPane();
    final JCheckBox isActiveCheckBox = new JCheckBox("Enabler activated", isActive);
    isActiveCheckBox.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        isActive = isActiveCheckBox.isSelected();
      }
    });
    content.add(isActiveCheckBox, BorderLayout.CENTER);
    content.add(new JLabel("http://chrriis.brainlex.com/awtenabler"), BorderLayout.SOUTH);
    setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    setResizable(false);
    pack();
    setVisible(true);
  }

  public static void main(String[] args) {
    System.out.println("AWTEnabler 1.0");
    System.out.println("Copyright (c) 2003  Christopher Deckers (chrriis@brainlex.com)");
    System.out.println("http://chrriis.brainlex.com/awtenabler");
    System.out.println();
    if(args.length < 1) {
      System.out.println("Usage: <JavaAwtEnabler> MainClass param1 param2 ... paramn");
      System.exit(0);
    }
    new AwtEnabler();
    String[] arguments = new String[args.length - 1];
    for(int i=0; i<arguments.length; i++) {
      arguments[i] = args[i-1];
    }
    try {
      Class.forName(args[0]).getMethod("main", new Class[] {String[].class}).invoke(null, new Object[] {arguments});
    } catch(Exception e) {
      e.printStackTrace();
    }
  }
  
}
